* in this example, the respondent ID is in col 1-8, followed by age (in
*  years) and gender (1=Male 2=Female), then responses begin in 
*  column 25;

DATA SCAN1;
  INFILE IN;
  INPUT @1 RESPID $8. AGE GENDER
     @25 CEREAL SKIMMILK EGGS SAUSAGE MARGBR CITJUICE FRUIT HOTDOG
      CHEESE FRIEDPOT MARGVEG MAYO SALDRS RICE MARGRICE LOFATMRG
      ALLFAT SEX AGE;

  %MACRO MKFD (IN,OUT);
    IF &IN = 1 THEN &OUT=0;
     ELSE IF &IN = 2 THEN &OUT= .018;
     ELSE IF &IN = 3 THEN &OUT= .066;
     ELSE IF &IN = 4 THEN &OUT= .214;
     ELSE IF &IN = 5 THEN &OUT= .499;
     ELSE IF &IN = 6 THEN &OUT= .784;
     ELSE IF &IN = 7 THEN &OUT= 1;
     ELSE IF &IN = 8 THEN &OUT= 2;
     ELSE IF &IN = 9 OR &IN=. THEN &OUT=.;
  %MEND MKFD;

  %MKFD(CEREAL,F2);
  %MKFD(SKIMMILK,F3);
  %MKFD(EGGS,F4);
  %MKFD(SAUSAGE,F5);
  %MKFD(MARGBR,F6);
  %MKFD(CITJUICE,F7);
  %MKFD(FRUIT,F8);
  %MKFD(HOTDOG,F9);
  %MKFD(CHEESE,F10);
  %MKFD(FRIEDPOT,F11);
  %MKFD(MARGVEG,F12);
  %MKFD(MAYO,F13);
  %MKFD(SALDRS,F14);
  %MKFD(RICE,F15);
  %MKFD(MARGRICE,F16);

  LABEL F2='COLD CEREAL'
        F3='SKIM MILK'
        F4='EGGS'
        F5='SAUSAGE'
        F6='MARG-1, BREADS'
        F7='ORANGE JUICE'
        F8='FRUIT'
        F9='HOT DOGS'
        F10='CHEESE'
        F11='FRENCH FRIES'
        F12='MARG-2 VEG'
        F13='MAYO'
        F14='SALAD DRESSINGS'
        F15='RICE'
        F16='MARG-3, RICE';

  TOTFAT=SUM(F6,F12,F16);

  IF LOFATMRG IN (1,2) THEN DO; FATREAL=1; DIETFAT=0; END;
   ELSE IF LOFATMRG EQ 3 THEN DO; FATREAL=.75; DIETFAT=.25; END;
   ELSE IF LOFATMRG EQ 4 THEN DO; FATREAL=.5; DIETFAT=.5; END;
   ELSE IF LOFATMRG EQ 5 THEN DO; FATREAL=.25; DIETFAT=.75; END;
   ELSE IF LOFATMRG EQ 6 THEN DO; FATREAL=0; DIETFAT=1; END;

  REGFAT=FATREAL*TOTFAT;

* REVISED SAS code (Jul. 20, 2004) to estimate percent energy from fat 
*  using gender-age specific portion sizes;

if (gender=1 and 18 <= age < 28) then do;
    F2A=74.666667*F2;
    F4A=92.000000*F4;
    F9A=114.000000*F9;
    F7A=373.200000*F7;
    F10A=33.360000*F10;
    F11A=112.500000*F11;
    F3A=366.666667*F3;
    F5A=25.000000*F5;
    F8A=131.750000*F8;
    F13A=13.750000*F13;
    F14A=36.720000*F14;
    REGFATA=9.540000*REGFAT;
    F15A=213.625000*F15;
  end;
else if (gender=1 and 28 <= age < 38) then do;
    F2A=61.500000*F2;
    F4A=92.000000*F4;
    F9A=85.500000*F9;
    F7A=311.000000*F7;
    F10A=28.350000*F10;
    F11A=114.000000*F11;
    F3A=250.000000*F3;
    F5A=40.250000*F5;
    F8A=128.000000*F8;
    F13A=13.750000*F13;
    F14A=44.060000*F14;
    REGFATA=9.540000*REGFAT;
    F15A=195.000000*F15;
  end;
else if (gender=1 and 38 <= age < 48) then do;
    F2A=57.500000*F2;
    F4A=92.000000*F4;
    F9A=88.000000*F9;
    F7A=249.000000*F7;
    F10A=28.350000*F10;
    F11A=100.000000*F11;
    F3A=250.000000*F3;
    F5A=32.000000*F5;
    F8A=123.200000*F8;
    F13A=13.750000*F13;
    F14A=31.250000*F14;
    REGFATA=9.460000*REGFAT;
    F15A=166.000000*F15;
  end;
else if (gender=1 and 48 <= age < 58) then do;
    F2A=56.000000*F2;
    F4A=92.000000*F4;
    F9A=114.000000*F9;
    F7A=249.000000*F7;
    F10A=28.350000*F10;
    F11A=100.000000*F11;
    F3A=245.000000*F3;
    F5A=32.000000*F5;
    F8A=127.500000*F8;
    F13A=13.750000*F13;
    F14A=31.250000*F14;
    REGFATA=9.200000*REGFAT;
    F15A=165.000000*F15;
  end;
else if (gender=1 and 58 <= age < 68) then do;
    F2A=46.000000*F2;
    F4A=92.000000*F4;
    F9A=57.000000*F9;
    F7A=248.000000*F7;
    F10A=28.350000*F10;
    F11A=85.500000*F11;
    F3A=214.375000*F3;
    F5A=27.000000*F5;
    F8A=122.000000*F8;
    F13A=9.150000*F13;
    F14A=29.400000*F14;
    REGFATA=7.883333*REGFAT;
    F15A=165.000000*F15;
  end;
else if (gender=1 and 68 <= age < 78) then do;
    F2A=39.000000*F2;
    F4A=80.000000*F4;
    F9A=57.000000*F9;
    F7A=186.750000*F7;
    F10A=24.000000*F10;
    F11A=85.500000*F11;
    F3A=198.937500*F3;
    F5A=26.000000*F5;
    F8A=118.000000*F8;
    F13A=13.750000*F13;
    F14A=29.400000*F14;
    REGFATA=7.100000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=1 and age >= 78) then do;
    F2A=33.000000*F2;
    F4A=80.000000*F4;
    F9A=57.000000*F9;
    F7A=186.750000*F7;
    F10A=22.880000*F10;
    F11A=97.000000*F11;
    F3A=160.725000*F3;
    F5A=24.000000*F5;
    F8A=114.250000*F8;
    F13A=4.580000*F13;
    F14A=29.380000*F14;
    REGFATA=7.000000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=2 and 18 <= age < 28) then do;
    F2A=50.000000*F2;
    F4A=80.000000*F4;
    F9A=57.000000*F9;
    F7A=249.000000*F7;
    F10A=26.175000*F10;
    F11A=79.500000*F11;
    F3A=245.000000*F3;
    F5A=26.000000*F5;
    F8A=118.000000*F8;
    F13A=13.750000*F13;
    F14A=30.630000*F14;
    REGFATA=7.000000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=2 and 28 <= age < 38) then do;
    F2A=49.500000*F2;
    F4A=80.000000*F4;
    F9A=57.000000*F9;
    F7A=248.800000*F7;
    F10A=21.000000*F10;
    F11A=70.000000*F11;
    F3A=245.000000*F3;
    F5A=25.000000*F5;
    F8A=118.000000*F8;
    F13A=6.880000*F13;
    F14A=29.400000*F14;
    REGFATA=6.290000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=2 and 38 <= age < 48) then do;
    F2A=44.000000*F2;
    F4A=69.000000*F4;
    F9A=57.000000*F9;
    F7A=248.800000*F7;
    F10A=22.500000*F10;
    F11A=70.000000*F11;
    F3A=244.800000*F3;
    F5A=24.000000*F5;
    F8A=118.000000*F8;
    F13A=9.170000*F13;
    F14A=29.400000*F14;
    REGFATA=5.925000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=2 and 48 <= age < 58) then do;
    F2A=43.500000*F2;
    F4A=80.000000*F4;
    F9A=114.000000*F9;
    F7A=217.875000*F7;
    F10A=22.063333*F10;
    F11A=70.000000*F11;
    F3A=229.690000*F3;
    F5A=24.000000*F5;
    F8A=118.000000*F8;
    F13A=9.183333*F13;
    F14A=29.400000*F14;
    REGFATA=7.095000*REGFAT;
    F15A=155.000000*F15;
  end;
else if (gender=2 and 58 <= age < 68) then do;
    F2A=33.000000*F2;
    F4A=68.000000*F4;
    F9A=57.000000*F9;
    F7A=186.750000*F7;
    F10A=24.000000*F10;
    F11A=66.000000*F11;
    F3A=196.000000*F3;
    F5A=18.000000*F5;
    F8A=118.000000*F8;
    F13A=6.110000*F13;
    F14A=29.380000*F14;
    REGFATA=5.296667*REGFAT;
    F15A=122.250000*F15;
  end;
else if (gender=2 and 68 <= age < 78) then do;
    F2A=33.000000*F2;
    F4A=56.000000*F4;
    F9A=57.000000*F9;
    F7A=186.600000*F7;
    F10A=21.000000*F10;
    F11A=70.000000*F11;
    F3A=183.750000*F3;
    F5A=19.500000*F5;
    F8A=112.427143*F8;
    F13A=10.310000*F13;
    F14A=29.380000*F14;
    REGFATA=5.320000*REGFAT;
    F15A=158.000000*F15;
  end;
else if (gender=2 and age >= 78) then do;
    F2A=33.500000*F2;
    F4A=46.000000*F4;
    F9A=57.000000*F9;
    F7A=186.750000*F7;
    F10A=25.800000*F10;
    F11A=64.000000*F11;
    F3A=183.750000*F3;
    F5A=16.000000*F5;
    F8A=109.000000*F8;
    F13A=4.580000*F13;
    F14A=22.030000*F14;
    REGFATA=4.865000*REGFAT;
    F15A=83.000000*F15;
  end;


  if gender=1 then
    predict_pcf = 30.795765 - (0.022086*F2A) - (0.009666*F3A) +
        (0.026997*F4A) + (0.109569*F5A) - (0.004946*F7A)
        - (0.009346*F8A) +
        (0.040118*F9A) + (0.069945*F10A) + (0.024262*F11A) +
        (0.145026*F13A) + (0.114649*F14A) - (0.017017*F15A) +
        (0.167937*REGFATA);

  else if gender=2 then
    predict_pcf = 29.865870 - (0.045171*F2A) - (0.010393*F3A) +
        (0.036787*F4A) + (0.198808*F5A) - (0.010141*F7A)
        - (0.012103*F8A) +
        (0.106686*F9A) + (0.103239*F10A) + (0.040374*F11A) +
        (0.287044*F13A) + (0.182758*F14A) - (0.014224*F15A) +
        (0.326702*REGFATA);
